{{- define "kublr.alertManagerEnabled" -}}
  {{- include "kublrCommon.getValue" (merge (dict "key" "alertmanager.enabled") . ) -}}
{{- end -}}

{{- define "kublr.alertManagerPersistence" -}}
  {{- include "kublrCommon.getValue" (merge (dict "key" "alertmanager.persistent") . ) -}}
{{- end -}}

{{- define "kublr.alertManagerStorageSize" -}}
  {{- include "kublrCommon.getValue" (merge (dict "key" "alertmanager.size") . ) -}}
{{- end -}}

{{- define "kublr.grafanaEnabled" -}}
  {{- include "kublrCommon.getValue" (merge (dict "key" "grafana.enabled") . ) -}}
{{- end -}}

{{- define "kublr.grafanaPersistence" -}}
  {{- include "kublrCommon.getValue" (merge (dict "key" "grafana.persistent") . ) -}}
{{- end -}}

{{- define "kublr.grafanaStorageSize" -}}
  {{- include "kublrCommon.getValue" (merge (dict "key" "grafana.size") . ) -}}
{{- end -}}

{{- define "kublr.prometheusPersistence" -}}
  {{- include "kublrCommon.getValue" (merge (dict "key" "prometheus.persistent") . ) -}}
{{- end -}}

{{- define "kublr.prometheusStorageSize" -}}
  {{- include "kublrCommon.getValue" (merge (dict "key" "prometheus.size") . ) -}}
{{- end -}}

{{- define "kublr.prometheusMemoryLimit" -}}
{{- if eq (include "kublrCommon.configContext" .) "platform" -}}
  "4G"
{{- else }}
  {{- .Values.prometheus.resources.limits.memory | default "1G" -}}
{{- end -}}
{{- end -}}

{{- define "kublr.prometheusEndpoint" -}}
{{- if eq (include "kublrCommon.configContext" .) "platformClient" -}}
  "/prometheus"
{{- else }}
  "{{ default "" .Values.global.kublrConfig.controlPlaneEndpoints.baseURL }}/prometheus"
{{- end -}}
{{- end -}}

{{- define "kublr.prometheusRetentionPeriod" -}}
{{- if eq (include "kublrCommon.configContext" .) "platformClient" -}}"10m"{{- end -}}
{{- end -}}

{{- define "kublr.prometheusBlockDuration" -}}
{{- if eq (include "kublrCommon.configContext" .) "platformClient" -}}"5m"{{- end -}}
{{- end -}}

{{- define "kublr.controlPlaneAuthTokenEndpoint" -}}
{{- if eq (include "kublrCommon.configContext" .) "platform" -}}
  {{- default "/" .Values.global.kublrConfig.controlPlaneEndpoints.authTokenEndpoint -}}
{{- end -}}
{{- end -}}

{{- define "kublr.centralizedMonitoringEnabled" -}}
{{- if eq (include "kublrCommon.configContext" .) "platform" -}}true{{- end -}}
{{- end -}}

{{- define "kublr.selfHostedMonitoringEnabled" -}}
{{- if eq (include "kublrCommon.configContext" .) "selfHosted" -}}true{{- end -}}
{{- end -}}