{{/* KUBLR HOOK UPDATE RESOURCE

Example Usage:
{{- $scriptParams := merge (dict 
  "hookResourceName" "kibana" 
  "hookResourceType" "Deployment" 
  "hookExpectedLabels" (dict 
    "app" (printf "%s-%s" .Release.Name "kibana")
  )
) . -}}
{{- $script := include "kublrCommon.update.resource" $scriptParams -}}
*/}}
{{- define "kublrCommon.update.resource" -}}
set -x

HOOK_RESOURCE_TYPE="{{ .hookResourceType | default "Deployment" }}"
RESOURCE_NAME="{{ .Release.Name }}-{{ .hookResourceName }}"

# Determine the API version for the resource type.
API_VERSION="{{ if eq .hookResourceType "Deployment" }}{{ .Values.kublrCommon.apiVersions.deployment }}
{{- else if eq .hookResourceType "DaemonSet" }}{{ .Values.kublrCommon.apiVersions.daemonSet }}
{{- else if eq .hookResourceType "StatefulSet" }}{{ .Values.kublrCommon.apiVersions.statefulSet }}
{{- else }}"apps/v1"{{ end }}"

# Check if we have access to the RESOURCE in the namespace; exit with error if not.
kubectl get $HOOK_RESOURCE_TYPE -n {{ .Release.Namespace }} || exit 1

# Check if the specific RESOURCE exists. Exit the script with success if it doesn't.
kubectl get $HOOK_RESOURCE_TYPE $RESOURCE_NAME -n {{ .Release.Namespace }} || exit 0

# Generate the EXPECTED_SELECTOR by creating a dry-run RESOURCE with the desired specs.
EXPECTED_SELECTOR="$(kubectl apply --dry-run=server -o jsonpath='{.spec.selector}' -f <(echo "
apiVersion: $API_VERSION
kind: $HOOK_RESOURCE_TYPE
metadata: {name: expected-resource}
spec:
  serviceName: expected-resource
  selector:
    matchLabels:
      {{- toYaml .hookExpectedLabels | nindent 6 }}
  template:
    metadata:
      labels:
        {{- toYaml .hookExpectedLabels | nindent 8 }}
    spec: {containers: [{name: main, image: img}]}
" ))"

# Fetch the ACTUAL_SELECTOR from the existing RESOURCE in the cluster.
ACTUAL_SELECTOR="$(kubectl get $HOOK_RESOURCE_TYPE $RESOURCE_NAME -n {{ .Release.Namespace }} -o jsonpath='{.spec.selector}')"

# Compare the EXPECTED_SELECTOR and the ACTUAL_SELECTOR.
# If they are not the same, delete the existing RESOURCE.
if [ "$EXPECTED_SELECTOR" != "$ACTUAL_SELECTOR" ];
then
  kubectl delete $HOOK_RESOURCE_TYPE --field-selector metadata.name=$RESOURCE_NAME -n {{ .Release.Namespace }} || exit 1
  echo "$RESOURCE_NAME $HOOK_RESOURCE_TYPE was removed."
fi
{{- end }}