{{/* KEYCLOAK-INIT

Example Usage:
{{- include "kublrCommon.keycloak-init" (merge (dict "appName" "prometheus") . ) | nindent 6 }}
*/}}
{{- define "kublrCommon.keycloak-init" -}}
{{- $appName := .appName -}}
{{- $keycloakServer := "" -}}
{{- $keycloakInit := dict -}}
{{- $globalKeycloakInit := default .Values.kublrCommon.global.keycloak.init .Values.global.keycloak.init  -}}
{{- if eq $appName "controller" -}}
{{- $keycloakServer = index .Values "centralizedMonitoring" "controller" "config" "authEndpoint" -}}
{{- $keycloakInit = merge (index .Values "centralizedMonitoring" "controller" "authentication" "keycloak" "init" | default dict) $globalKeycloakInit | deepCopy -}}
{{- else -}}
{{- $keycloakServer = index .Values $appName "authentication" "oidc" "authUrl" -}}
{{- $keycloakInit = merge (index .Values $appName "authentication" "keycloak" "init" | default dict) $globalKeycloakInit | deepCopy -}}
{{- end -}}
{{- $defaultArgs := dict 
  "keycloak-server" $keycloakServer
  "keycloak-server-endpoint" ($keycloakInit.authRelativePath | default "/auth")
  "keycloak-admin-username" ($keycloakInit.username | default "admin")
  "keycloak-admin-password" "$(KEYCLOAK_PASSWORD)"
  "insecure-skip-tls-verify" "true"
  "config" (print "/etc/keycloak-init/" $appName ".conf")
  "output" "kubernetes-secret"
  "output-kubernetes-secret-namespace" .Release.Namespace
  "output-kubernetes-secret-name" (print .Release.Name "-" $appName "-jwks")
  "verbose" "true"
  "wait-timeout" "10m0s"
-}}
{{- /* Create a temporary dictionary to store processed extraArgs */ -}}
{{- $tempArgs := dict -}}
{{- range $key, $value := $keycloakInit.extraArgs -}}
  {{- /* Use tpl function to process the value as a template string */ -}}
  {{- $processedValue := tpl (toString $value) $ -}}
  {{- /* Update the temporary dictionary with the processed value */ -}}
  {{- $_ := set $tempArgs $key $processedValue -}}
{{- end -}}
{{- /* Merge the processed extraArgs with the defaultArgs */ -}}
{{- $finalArgs := merge $tempArgs $defaultArgs -}}

- name: keycloak-init
  image: {{ include "kublrCommon.images" (merge ( dict "image" $keycloakInit.image "overrideRegistry" "cr_kublr_com" ) . ) }}
  imagePullPolicy: {{ $keycloakInit.imagePullPolicy | default "IfNotPresent" }}
  args:
    - client
    {{- range $key, $value := $finalArgs }}
    - --{{ $key }}={{ $value }}
    {{- end }}
  env:
    - name: KEYCLOAK_PASSWORD
      valueFrom:
        secretKeyRef:
          name: {{ $keycloakInit.secretName }}
          key: {{ $keycloakInit.secretKey | default "password" }}
    {{- if $keycloakInit.extraEnvVars }}
    {{- toYaml $keycloakInit.extraEnvVars | nindent 4 }}
    {{- end }}
  {{- if or $keycloakInit.extraEnvVarsCM $keycloakInit.extraEnvVarsSecret }}
  envFrom:
    {{- with $keycloakInit.extraEnvVarsCM }}
    - configMapRef:
        name: {{ . }}
        optional: true
    {{- end }}
    {{- with $keycloakInit.extraEnvVarsSecret }}
    - secretRef:
        name: {{ . }}
        optional: true
    {{- end }}
  {{- end }}
  volumeMounts:
    - name: keycloak-init-config
      mountPath: /etc/keycloak-init/{{ $appName }}.conf
      subPath: {{ $appName }}.conf
    - name: keycloak-init-config
      mountPath: /etc/keycloak-init/version
      subPath: version
    {{- if $keycloakInit.extraVolumeMounts }}
    {{- tpl (toYaml $keycloakInit.extraVolumeMounts)  | nindent 4 }}
    {{- end }}
{{- end }}