{{/* KUBLR INGRESS

Example Usage:
{{- $grafana := dict 
  "appName" "grafana" 
  "oidcPort" 9180 
  "defaultPort" 80 
  "path" "/alerts" 
  "annotations" (dict "helm.sh/hook" "post-install,post-upgrade" "helm.sh/hook-weight" "0") 
  "labels" (dict "label-key" "label-value") 
  "ingressClassName" .Values.grafana.ingress.ingressClassName
  "globalIngressHosts" .Values.global.ingress.hosts 
  "appIngressHosts" .Values.grafana.ingress.hosts 
  "authentication" .Values.grafana.authentication 
-}}
{{- include "kublrCommon.render.ingress" (merge $grafana .) }}
*/}}
{{- define "kublrCommon.render.ingress" -}}
{{- $appName := .appName }}
{{- $defaultPort := .defaultPort }}
{{- $oidcPort := .oidcPort }}
{{- $defaultPort := .defaultPort }}
{{- $authentication := .authentication }}
{{- $path := .path }}
{{- $inputAnnotations := default dict .annotations }}
{{- $serviceName := default (printf "%s-%s" .Release.Name $appName) .serviceName -}}

{{- $hosts := dict }}
{{- if eq (kindOf .globalIngressHosts) "string" }}
  {{- $_ := set $hosts .globalIngressHosts dict }}
{{- else if eq (kindOf .globalIngressHosts) "map" }}
  {{- $hosts = merge $hosts .globalIngressHosts }}
{{- end }}

{{/* Handle appIngressHosts */}}
{{- if eq (kindOf .appIngressHosts) "string" }}
  {{- $_ := set $hosts .appIngressHosts dict }}
{{- else if eq (kindOf .appIngressHosts) "map" }}
  {{- $hosts = merge $hosts .appIngressHosts }}
{{- end }}

{{/* Get default annotations from values.yaml or use an empty dictionary if not set */}}
{{- $defaultAnnotations := .Values.kublrCommon.global.ingress.defaultAnnotations | default dict }}
{{/* Merge provided annotations with defaults */}}
{{- $annotations := merge $inputAnnotations $defaultAnnotations }}

{{/* Remove any annotations that are in the defaultAnnotationsExclude list */}}
{{- $defaultAnnotationsExclude := dict }}
{{- if .defaultAnnotationsExclude }}
  {{- $defaultAnnotationsExclude = .defaultAnnotationsExclude }}
{{- end }}
{{- range $key, $value := $annotations }}
  {{- if hasKey $defaultAnnotationsExclude $key }}
    {{- $_ := unset $annotations $key }}
  {{- end }}
{{- end }}

---
apiVersion: {{ .Values.kublrCommon.apiVersions.ingress }}
kind: Ingress
metadata:
  name: '{{ .Release.Name }}-{{ .appName }}'
  labels:
    {{- $commonLabels := include "kublrCommon.labels" (merge (dict "appName" .appName) . ) | fromYaml }}
    {{- if .labels }}
    {{- $mergedLabels := include "mergeDicts" (list $commonLabels .labels) | fromYaml }}
    {{- toYaml $mergedLabels | nindent 4 }}
    {{- else }}
    {{- toYaml $commonLabels | nindent 4 }}
    {{- end }}
  annotations:
    {{- toYaml $annotations | nindent 4 }}
spec:
  {{- if .ingressClassName }}
  ingressClassName: {{ .ingressClassName | quote }}
  {{- end }}
  rules:
  {{- range $host, $val := $hosts }}
  - {{- if and $host (ne $host "") (ne $host "*") }}
    host: {{ $host | quote }}
    {{- end }}
    http:
      paths:
        - path: {{ default (print "/" $appName) $path }}
          pathType: Prefix
          backend:
            service:
              name: {{ $serviceName }}
              port:
                number: {{ if and $authentication $authentication.enabled $authentication.oidc.enabled }}{{ $oidcPort }}{{ else }}{{ $defaultPort }}{{ end }}
  {{- end }}
  tls:
  {{- $tls := dict }}
  {{- range $host, $val := $hosts }}
    {{- if not $host }}{{ $host = "*" }}{{- end }}
    {{- $secret := ternary $val.secret (printf "%s-tls" $host | replace "*" "all") ($val.secret | not | empty ) }}
    {{- if hasKey $tls $secret }}
      {{- $tls = mergeOverwrite $tls (dict $secret ( append ( get $tls $secret ) (printf "%s" $host | replace "*" "") ) ) }}
    {{- else }}
      {{- $tls = mergeOverwrite $tls (dict $secret ( list (printf "%s" $host | replace "*" "") ) ) }}
    {{- end }}
  {{- end }}

  {{- range $secret, $hostsList := $tls }}
  - secretName: {{ $secret | quote }}
    {{- if (compact $hostsList) }}
    hosts:
      {{- compact $hostsList | toYaml | nindent 6 }}
    {{- end }}
  {{- end }}
{{- end -}}