j = os.getenv("J")
if j == nil then
    j = "j"
end

function flat(tag, timestamp, record)
    if record[j] == nil then
        return 0, 0, 0
    end

    new_record = record -- we will add flatten fields from "j" subtree (which will be deleted by modify filter of fluentbit)

    function flatten (record, name)
        if type(record) == "table" then
            for key, val in pairs(record) do
                fkey = name  .. key .. "."
                flatten(val, fkey)
            end
        else
            name = string.sub(name,0,-2)
            if type(record) == "string" then
                new_record[name .. ".s"]= record
            elseif type(record) == "number" then
                new_record[name .. ".n"]= record
                new_record[name .. ".s"]= tostring(record)
            elseif type(record) == "boolean" then
                new_record[name .. ".b"]= record
                new_record[name .. ".s"]= tostring(record)
            else
                new_record[name]= record
            end
        end
        return
    end

    function flatten2 (record, name, accum, data)
        -- print ("== name=" .. tostring(name) .. ", == record=" .. tostring(record) .. ", == accum=" .. tostring(accum) .. ", == data=" .. tostring(data))

        if record == nil then
            return
        end

        local new_data = false
        if data == nil then
            data = {key=string.sub(name,0,-2), type={}, value_string={}}
            new_data = true
        end

        if type(record) == "table" then
            for key, val in pairs(record) do
                -- normalize key type
                if ( type(key) ~= "number" and type(key) ~= "string" ) or key == "" then
                    key = 0
                end

                if type(key) == "number" then
                    flatten2(val, name, accum, data)
                else
                    fkey = name  .. key .. "."
                    flatten2(val, fkey, accum)
                end
            end
        else
            local record_type = type(record)
            data.value_string[#(data.value_string)+1] = tostring(record)
            if record_type ~= "string" and record_type ~= "number" and record_type ~= "boolean" then
                record_type = "unknown"
            end
            data["type"][record_type] = record_type
            if record_type == "number" then
                if data.value_number == nil then
                    data.value_number = {}
                end
                data.value_number[#(data.value_number)+1] = record
            elseif record_type == "boolean" then
                if data.value_boolean == nil then
                    data.value_boolean = {}
                end
                data.value_boolean[#(data.value_boolean)+1] = record
            end
        end

        if new_data and #(data.value_string) > 0 then
            -- print ("==== 1 name=" .. name .. ", data=" .. tostring(#(data["type"])))
            local types = {}
            for key, val in pairs(data["type"]) do
                types[#types+1] = key
            end
            data["type"] = types
            accum[#accum+1] = data
        end

        return
    end

    -- flatten (record[j], j .. ".") -- initiate from 'j' prepared by k8s filter
    if record[j] ~= nil then
        local flattened = {}
        flatten2 (record[j], "", flattened) -- initiate from 'j' prepared by k8s filter
        new_record.log_parsed = flattened
    end

    return 2,0,new_record -- 2,0 means replace record but not timestamp
end

function dedot(tag, timestamp, record)
    if record["kubernetes"] == nil then
        return 0, 0, 0
    end
    dedot_keys(record["kubernetes"]["annotations"])
    dedot_keys(record["kubernetes"]["labels"])
    return 2, timestamp, record
end

function dedot_keys(map)
    if map == nil then
        return
    end
    local new_map = {}
    local changed_keys = {}
    for k, v in pairs(map) do
        local deslashed = string.gsub(k, "%/", "_")
        local dedotted = string.gsub(deslashed, "%.", "_")
        if dedotted ~= k then
            new_map[dedotted] = v
            changed_keys[k] = true
        end
    end
    for k in pairs(changed_keys) do
        map[k] = nil
    end
    for k, v in pairs(new_map) do
        map[k] = v
    end
end

function addfields(tag, timestamp, record)
    record["tag"] = tag -- todo add by filter if it is possible
    if record["time"] == nil then
        record["time"]=os.date("%Y-%m-%dT%X.", timestamp['sec']) .. string.format("%09d",math.floor(timestamp['nsec']) ) .. "Z"
    end
    return 2, timestamp, record
end

function liftaudit(tag, timestamp, record)
    local lifted = {}
    local new_record = {audit_parsed=lifted}
    for key, val in pairs(record) do
        if key == "filepath" or key == "log" then
            new_record[key] = val
        else
            lifted[key] = val
        end
    end
    return 2, timestamp, new_record
end

function remove_managed_fields(tag, timestamp, record)
    rec = record
    modified = false
    if rec["audit_parsed"] ~= nil then
       rec = rec["audit_parsed"]
    end
    if rec["requestObject"] ~= nil then

      if rec["requestObject"]["metadata"] ~= nil
          and rec["requestObject"]["metadata"]["managedFields"] ~= nil then
            rec["requestObject"]["metadata"]["managedFields"] = nil
            modified = true
      end
      if rec["requestObject"]["data"] ~= nil
          and rec["requestObject"]["data"]["release"] ~= nil then
            rec["requestObject"]["data"]["release"] = string.format("kublr removed %d bytes of data" ,string.len (rec["requestObject"]["data"]["release"]) )
            modified = true
      end

      if modified then
          return 2, timestamp, record
      else
          return 0, 0, 0
      end
    end
end
