{{/*
Expand the name of the elasticsearch part of chart.
*/}}
{{- define "elasticsearch.name" -}}
{{- default .Chart.Name .Values.elasticsearch.nameOverride | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
*/}}
{{- define "elasticsearch.fullname" -}}
{{- if .Values.elasticsearch.fullnameOverride -}}
{{- .Values.elasticsearch.fullnameOverride | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- $name := default .Chart.Name .Values.elasticsearch.nameOverride -}}
{{- if contains $name .Release.Name -}}
{{- .Release.Name | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}
{{- end -}}
{{- end -}}

{{/*
Create a default fully qualified client name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
*/}}
{{- define "elasticsearch.client.fullname" -}}
{{ template "elasticsearch.fullname" . }}-client
{{- end -}}

{{- define "image" -}}
{{- $config := .config -}}
{{- $base := .base -}}
{{- $suffix := "-oss" -}}
{{- if .Values.elasticsearch.xpackEnabled -}}
  {{- $suffix = "" -}}
{{- end -}}
{{- $name := printf "%s%s" $base $suffix -}}
{{- if and $config.name (ne $config.name nil) -}}
  {{- $name = $config.name -}}
{{- else -}}
  {{- $name = printf "%s%s" $base $suffix -}} {{/* Ensure $name is always set */}}
{{- end -}}
{{- $image := dict "name" $name "tag" $config.tag "registry" $config.registry -}}
{{- include "kublrCommon.images" (merge (dict "image" $image "overrideRegistry" "cr_kublr_com") .) -}}
{{- end -}}


{{- define "elasticsearch.image" -}}
{{- $config := .Values.elasticsearch.image -}}
{{- $base := "kublr/elasticsearch" -}}
{{- if .Values.searchguard.enabled -}}
    {{- $config = .Values.searchguard.elasticsearch.image -}}
    {{- $base = "kublr/elasticsearch-sg" -}}
{{- end -}}
{{- include "image" (merge (dict "config" $config "base" $base) .) -}}
{{- end -}}


{{- define "kibana.image" -}}
{{- $config := .Values.kibana.image -}}
{{- $base := "kublr/kibana" -}}
{{- if .Values.searchguard.enabled -}}
    {{- $config = .Values.searchguard.kibana.image -}}
    {{- $base = "kublr/kibana-sg" -}}
{{- end -}}
{{- include "image" (merge (dict "config" $config "base" $base) .) -}}
{{- end -}}

{{- define "kibana.init.space_path" -}}
{{- if and .Values.elasticsearch.xpackEnabled (ne .Values.kibana.init.kublrSpace "default") (ne .Values.kibana.init.kublrSpace "") }}
{{- default "" (printf "/s/%s" .Values.kibana.init.kublrSpace) -}}
{{- end }}
{{- end -}}

{{- define "logstash.image" -}}
{{- $name := default "kublr/logstash-oss" $.Values.logstash.image.name -}}
{{- if .Values.elasticsearch.xpackEnabled -}}
{{- $name = default "kublr/logstash" $.Values.logstash.image.name -}}
{{- end -}}
{{- $image := dict "name" $name "tag" $.Values.logstash.image.tag "registry" $.Values.logstash.image.registry -}}
{{- include "kublrCommon.images" (merge (dict "image" $image "overrideRegistry" "cr_kublr_com") .) -}}
{{- end -}}

{{- define "indexPattern" -}}
{{- $ipTemplate := index . 0 -}}
{{- $ := index . 1 -}}
{{- if and $.Values.elasticsearch.useDataStreams $.Values.centralLogging.createDsIndexPatterns -}}
{{ $ipTemplate }},.ds-{{ $ipTemplate }}
{{- else -}}
{{ $ipTemplate }}
{{- end -}}
{{- end -}}

{{- define "getCuratorEnabled" -}}
{{- if .Values.elasticsearch.enabled -}}
{{- if kindIs "bool" .Values.curator.enabled -}}
{{- .Values.curator.enabled -}}
{{- else -}}
{{- not .Values.global.platformSide -}}
{{- end -}}
{{- else -}}
{{- false -}}
{{- end -}}
{{- end -}}