{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "ingress.fullname" -}}
{{- if .Values.fullnameOverride }}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- $name := default .Chart.Name .Values.nameOverride }}
{{- if contains $name .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- if contains "kublr-ingress" .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" }}
{{- end }}
{{- end }}
{{- end }}
{{- end }}

{{/* Override name of nginx-ingress helm subchart */}}
{{- define "ingress-nginx.name" -}}
{{- print "nginx-ingress" -}}
{{- end -}}

{{- define "deployResource.script" -}}
{{- $filename := .filename }}
{{- $label := .label }}
{{- $component := .component }}
set -e
echo "=== Waiting for certmanager webhooks to start ==="

while ! kubectl -n ${NAMESPACE} apply -f /data/{{ $filename }} --dry-run ;
do
  echo "=== Will retry validate in 30 seconds ===";
  sleep 30;
done

echo "Deploy {{ $label }}"
kubectl -n ${NAMESPACE} apply -f /data/{{ $filename }} --prune -l component={{ $component }} \
--prune-allowlist 'cert-manager.io/v1/ClusterIssuer' \
--prune-allowlist 'cert-manager.io/v1/Certificate'
{{- end -}}
