{{/* KUBLR ROLE AND CLUSTERROLE

Example Usage:
{{- $prometheusRules := list 
  (dict 
    "apiGroups" (list "")
    "resources" (list "nodes" "nodes/proxy" "services" "endpoints" "pods")
    "verbs"     (list "get" "list" "watch")
  )
  (dict 
    "apiGroups" (list "extensions" "networking")
    "resources" (list "ingresses")
    "verbs"     (list "get" "list" "watch")
  )
  (dict 
    "nonResourceURLs" (list "/metrics")
    "verbs"           (list "get")
  )
  (dict 
    "apiGroups" (list "")
    "resources" (list "secrets")
    "verbs"     (list "*")
  )
}}
{{- include "kublrCommon.render.role" (merge (dict 
  "appName" "prometheus" 
  "isClusterRole" true 
  "rules" $prometheusRules
) . ) }}
*/}}
{{- define "kublrCommon.render.role" -}}
{{- $appName := .appName }}
{{- $isClusterRole := .isClusterRole }}
{{- $namespace := default .Release.Namespace .namespace }}
{{- $roleNamePrefix := default "" .roleNamePrefix }}
{{- $roleNameSuffix := default "" .roleNameSuffix }}
{{- $annotations := default (dict) .annotations }}
---
kind: {{ if $isClusterRole }}ClusterRole{{ else }}Role{{ end }}
apiVersion: {{ if $isClusterRole }}{{ .Values.kublrCommon.apiVersions.clusterRole }}{{ else }}{{ .Values.kublrCommon.apiVersions.role }}{{ end }}
metadata:
  name: '{{ if $roleNamePrefix }}{{ $roleNamePrefix }}{{ end }}{{ .Release.Name }}-{{ $appName }}{{ if $roleNameSuffix }}{{ $roleNameSuffix }}{{ end }}'
  {{ if not $isClusterRole }}namespace: {{ $namespace }}{{ end }}
  labels:
    {{- $commonLabels := include "kublrCommon.labels" (merge (dict "appName" .appName) . ) | fromYaml }}
    {{- if .labels }}
    {{- $mergedLabels := include "kublrCommon.mergeDicts" (list $commonLabels .labels) | fromYaml }}
    {{- toYaml $mergedLabels | nindent 4 }}
    {{- else }}
    {{- toYaml $commonLabels | nindent 4 }}
    {{- end }}
  {{- if .annotations }}
  annotations:
    {{- toYaml .annotations | nindent 4 }}
  {{- end }}
rules:
{{ toYaml .rules | indent 2 }}
{{- end }}