{{/* KUBLR ROLE AND CLUSTERROLE

Example Usage:
{{- include "kublrCommon.render.roleBinding" (merge (dict 
  "appName" "prometheus" 
  "isClusterRole" true 
) . ) }}
*/}}
{{- define "kublrCommon.render.roleBinding" -}}
{{- $appName := .appName }}
{{- $isClusterRole := .isClusterRole }}
{{- $namespace := default .Release.Namespace .namespace }}
{{- $bindingNamePrefix := default "" .bindingNamePrefix }}
{{- $bindingNameSuffix := default "" .bindingNameSuffix }}
{{- $annotations := default (dict) .annotations }}
{{- $kindValue := "Role" }}
{{- $subjectName := default (printf "%s-%s" .Release.Name $appName) .subjectName }}
{{- if $isClusterRole }}
{{- $kindValue = "ClusterRole" }}
{{- end }}
{{- $roleNameValue := printf "%s-%s" .Release.Name $appName }}
{{- $roleRefName := default $roleNameValue .roleRefName }}
{{- $roleRefApiGroup := default "rbac.authorization.k8s.io" .roleRefApiGroup }}
{{- $roleRefKind := default $kindValue .roleRefKind }}
{{- $extraSubjects := default (list) .extraSubjects }}
---
kind: {{ if $isClusterRole }}ClusterRoleBinding{{ else }}RoleBinding{{ end }}
apiVersion: {{ if $isClusterRole }}{{ .Values.kublrCommon.apiVersions.clusterRoleBinding }}{{ else }}{{ .Values.kublrCommon.apiVersions.roleBinding }}{{ end }}
metadata:
  name: '{{ if $bindingNamePrefix }}{{ $bindingNamePrefix }}{{ end }}{{ .Release.Name }}-{{ $appName }}{{ if $bindingNameSuffix }}{{ $bindingNameSuffix }}{{ end }}'
  {{ if not $isClusterRole }}namespace: {{ $namespace }}{{ end }}
  labels: 
    {{- $commonLabels := include "kublrCommon.labels" (merge (dict "appName" .appName) . ) | fromYaml }}
    {{- if .labels }}
    {{- $mergedLabels := include "kublrCommon.mergeDicts" (list $commonLabels .labels) | fromYaml }}
    {{- toYaml $mergedLabels | nindent 4 }}
    {{- else }}
    {{- toYaml $commonLabels | nindent 4 }}
    {{- end }}
  {{- if .annotations }}
  annotations:
    {{- toYaml .annotations | nindent 4 }}
  {{- end }}
subjects:
  - kind: ServiceAccount
    name: '{{ $subjectName }}'
    namespace: "{{ .Release.Namespace }}"
  {{- range $index, $subject := $extraSubjects }}
  - kind: {{ $subject.kind }}
    name: {{ $subject.name }}
    namespace: {{ $subject.namespace }}
  {{- end }}
roleRef:
  apiGroup: {{ $roleRefApiGroup }}
  kind: {{ $roleRefKind }}
  name: {{ $roleRefName }}
{{- end }}
