{{/* KUBLR SERVICE ACCOUNT

Example Usage:
{{- include "kublrCommon.render.serviceAccount" (merge (dict 
  "appName" "prometheus" 
) . ) }}
*/}}
{{- define "kublrCommon.render.serviceAccount" -}}
{{- $appName := .appName }}
{{- $namespace := default .Release.Namespace .namespace }}
---
apiVersion: {{ .Values.kublrCommon.apiVersions.serviceAccount }}
kind: ServiceAccount
{{- if or .imagePullSecretName .Values.imagePullSecretName }}
imagePullSecrets:
  - name: {{ default .Values.imagePullSecretName .imagePullSecretName }}
{{- end }}
metadata:
  name: '{{ .Release.Name }}-{{ $appName }}'
  namespace: {{ $namespace }}
  labels:
    {{- $commonLabels := include "kublrCommon.labels" (merge (dict "appName" .appName) . ) | fromYaml }}
    {{- if .labels }}
    {{- $mergedLabels := include "kublrCommon.mergeDicts" (list $commonLabels .labels) | fromYaml }}
    {{- toYaml $mergedLabels | nindent 4 }}
    {{- else }}
    {{- toYaml $commonLabels | nindent 4 }}
    {{- end }}
  {{- if .annotations }}
  annotations:
    {{- toYaml .annotations | nindent 4 }}
  {{- end }}
{{- end }}