{{- define "common.names.fullname" -}}
{{- $name := default .Chart.Name .Values.nameOverride -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}


{{- define "keycloak.fullname" -}}
{{ printf "%s" .Release.Name }}-keycloak
{{- end -}}

{{- define "keycloak.secret" -}}
{{ template "fullname" . }}-app-keycloa-http
{{- end -}}

{{/*
   Expand the name of postgresql-ha release
   https://github.com/helm/helm/issues/3920
*/}}
{{- define "postgresql-ha.postgresql" -}}
{{ printf "%s" .Release.Name }}-keycloak-postgres
{{- end -}}

{{/*
Return the Database hostname
*/}}
{{- define "keycloak.databaseHost" -}}
{{ printf "%s" .Release.Name }}-keycloak-postgres-pgpool
{{- end -}}

{{- define "postgresql-ha.pgpool" -}}
{{ printf "%s" .Release.Name }}-keycloak-postgres-pgpool
{{- end -}}

{{- define "mongodb.fullname" -}}
{{ printf "%s" .Release.Name }}-mongodb
{{- end -}}

{{- define "mongodb.service.nameOverride" -}}
    {{- if .Values.service -}}
        {{- if .Values.service.nameOverride }}
            {{- .Values.service.nameOverride -}}
        {{- else -}}
            {{ include "mongodb.fullname" . }}-gvr
        {{- end -}}
    {{- else -}}
        {{ include "mongodb.fullname" . }}-gvr
    {{- end }}
{{- end }}

{{- define "mongodb.url" -}}
{{- printf "mongodb://" -}}
{{- range $rs := until (.Values.mongodb.replicaCount|int) -}}
  {{- printf "%s-%d.%s:27017" (include "mongodb.fullname" $ ) $rs (include "mongodb.service.nameOverride" $ ) -}}
  {{- if lt $rs ( sub ($.Values.mongodb.replicaCount|int) 1 ) -}}
    {{- printf "," -}}
  {{- end -}}
{{- end -}}
{{- printf "/kublr-db?authSource=admin&replicaSet=%s" $.Values.mongodb.replicaSetName -}}
{{- end}}

{{/* fail (printf "DEBUG: %s :: %s :: %s" ( tpl ( include "postgresql-ha.postgresql" . ) . )  (include "keycloak.postgresql.fullname" . ) (include "postgresql-ha.postgresql" .) ) */}}

{{ define "preupgrade.Labels" }}
app: {{ template "fullname" . }}
release: "{{ .Release.Name }}"
stage: "kubrlmigration.preupgrade"
{{ end }}

{{/*
Create common labels.
*/}}
{{- define "keycloak.commonLabels" -}}
app.kubernetes.io/name: '{{ .Release.Name }}-keycloak'
helm.sh/chart: {{ .Chart.Name }}
app.kubernetes.io/instance: {{ .Release.Name | quote }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end -}}

{{/*
Return the Pgpool credentials secret.
*/}}
{{- define "postgresql-ha.pgpoolSecretName" -}}
{{- if .Values.global -}}
    {{- if .Values.global.pgpool -}}
        {{- if .Values.global.pgpool.existingSecret -}}
            {{- printf "%s" (tpl .Values.global.pgpool.existingSecret $) -}}
        {{- else if .Values.pgpool.existingSecret -}}
            {{- printf "%s" (tpl .Values.pgpool.existingSecret $) -}}
        {{- else -}}
            {{- printf "%s" (include "postgresql-ha.pgpool" .) -}}
        {{- end -}}
     {{- else if .Values.pgpool.existingSecret -}}
         {{- printf "%s" (tpl .Values.pgpool.existingSecret $) -}}
     {{- else -}}
         {{- printf "%s" (include "postgresql-ha.pgpool" .) -}}
     {{- end -}}
{{- else -}}
     {{- if .Values.pgpool.existingSecret -}}
         {{- printf "%s" (tpl .Values.pgpool.existingSecret $) -}}
     {{- else -}}
         {{- printf "%s" (include "postgresql-ha.pgpool" .) -}}
     {{- end -}}
{{- end -}}
{{- end -}}

{{/*
Return the appropriate apiVersion for podsecuritypolicy.
*/}}
{{- define "podsecuritypolicy.apiVersion" -}}
{{- if semverCompare "<1.10-0" .Capabilities.KubeVersion.GitVersion -}}
{{- print "extensions/v1beta1" -}}
{{- else -}}
{{- print "policy/v1beta1" -}}
{{- end -}}
{{- end -}}


{{/* Validate values of PostgreSQL - There must be one replica when upgrading repmgr extension */}}
{{- define "controlplane.validateValues.upgradeRepmgrExtension" -}}
{{- $oldChartVersion := include "oldChartVersion" . -}}
{{- if not (empty $oldChartVersion) -}}
{{- if and  (semverCompare "<1.25-0" $oldChartVersion) (semverCompare ">=1.25-0" .Chart.Version) -}}
{{- if and (not .Values.global.kublr_migration_preupgrade) (gt (int .Values.postgresql.postgresql.replicaCount) 1) }}
*******************************
ERROR: The value of postgresql.postgresql.replicaCount must equal 1 to upgrade KCP to v1.25.
Please specify it in the cluster specification for the upgrade to continue.
After upgrade is successfully complete, postgresql may be scaled back.
*******************************
{{- end -}}
{{- end -}}
{{- end -}}
{{- end -}}


{{- define "oldChartVersion" -}}
{{- $cr := lookup "feature.crd.kublr.com/v1" "ControlPlane" "kublr" "control-plane" -}}
{{- if $cr }}
{{- if $cr.status }}
{{- if $cr.status.lastSuccessfulVersion }}
{{- $cr.status.lastSuccessfulVersion }}
{{- end -}}
{{- end -}}
{{- else }}
{{- default "" .Values.global.oldChartVersion }}
{{- end -}}
{{- end -}}
