{{/* 
   * Define buildMongoAddresses function
   */}}
{{- define "kublr.mongoDBAddress" -}}
{{- $address := "" }}
{{- $releaseName := print ( .Release.Name ) }}
{{- range $i := until ( include "kublr.databaseReplicas" . | int ) -}}
  {{- if $i -}}
    {{- $address = print $address "," -}}
  {{- end -}}
  {{- $address = print $address (printf "%s-mongodb-%d.%s-mongodb-gvr:27017" $releaseName $i $releaseName) -}}
{{- end -}}
{{- print $address -}}
{{- end -}}

{{/*
   * Return the number of database replicas based on high availability configuration.
   */}}
{{- define "kublr.databaseReplicas" -}}
{{- if .Values.highAvailability -}}
  {{- print 3 -}}
{{- else -}}
  {{- print 1 -}}
{{- end -}}
{{- end -}}

{{/*
   * Return the number of service replicas based on high availability configuration.
   */}}
{{- define "kublr.servicesReplicas" -}}
{{- if .Values.highAvailability -}}
  {{- print 2 -}}
{{- else -}}
  {{- print 1 -}}
{{- end -}}
{{- end -}}